function robot = bras_2D()
specs.l1=0.32;   % longueur segment 1 en m
specs.l2=0.25;   % longueur segment 2 en m
specs.m1=1.5;    % masse segment 1 en kg
specs.m2=1.1;    % masse segment 2 en kg
specs.I1=0.017;  % inertie segment 1 en kg.m
specs.I2=0.005;  % inertie segment 2 en kg.m
specs.a=0.15;    % position centre de masse segment 1 en m 
specs.b=0.11;    % position centre de masse segment 2 en m 

% nombre de solides du robot
robot.NB = 2;

% dfinition de lambda (parents)
robot.parent = [0,1];

% dfinition du type de liaisons entre solides
robot.jtype{1}='r'; %liaison pivot
robot.jtype{2}='r';

% matrices de transformation spatiale entre solides (gomtrie du robot)

% plnr  compose/decompose planar-vector coordinate transform.
% X=plnr(theta,r) and [theta,r]=plnr(X)  compose a planar-vector coordinate
% transform X from its component parts theta and r, and decompose it into
% those parts, respectively.  theta is a scalar and r is a 2D vector.  r is
% returned as a column vector, but it can be supplied as a row or column
% vector.  X is the transform from A to B coordinates, in which frame B is
% located at point r (expressed in A coordinates) and is rotated by an
% angle theta (radians) relative to frame A.  If two arguments are supplied
% then they are assumed to be theta and r, otherwise X.
robot.Xtree{1}=plnr(0,[0 0]);
robot.Xtree{2}=plnr(0,[specs.l1 0]);

% masses, centres de masse, inerties des solides --> matrices d'inertie
% spatiale
% mcI  rigid-body inertia <--> mass, CoM and rotational inertia.
% rbi=mcI(m,c,I) and [m,c,I]=mcI(rbi) convert between the spatial or planar
% inertia matrix of a rigid body (rbi) and its mass, centre of mass and
% rotational inertia about the centre of mass (m, c and I).  In the spatial
% case, c is 3x1, I is 3x3 and rbi is 6x6.  In the planar case, c is 2x1, I
% is a scalar and rbi is 3x3.  In both cases, m is a scalar.  When c is an
% argument, it can be either a row or a column vector.  If only one
% argument is supplied then it is assumed to be rbi; and if it is a 6x6
% matrix then it is assumed to be spatial.  Otherwise, three arguments must
% be supplied, and if length(c)==3 then mcI calculates a spatial inertia
% matrix.  NOTE: (1) mcI(rbi) requires rbi to have nonzero mass; (2) if |c|
% is much larger than the radius of gyration, or the dimensions of the
% inertia ellipsoid, then extracting I from rbi is numerically
% ill-conditioned.

%rbi=mcI(m,c,I)

robot.I{1}=mcI(specs.m1,[specs.a 0],specs.I1);
robot.I{2}=mcI(specs.m2,[specs.b 0],specs.I2);


robot.gravity=[0 -9.81 0]';


end